# Inorganic Catalysis Efficiency Prediction

This project focuses on predicting the efficiency of inorganic catalysis using machine learning techniques. In this example, the **TiO2 photocatalysts dataset** is used for training and evaluation.

## Prerequisites

Make sure you have Python and the following dependencies installed:

- PyTorch 2.0
- torchvision
- numpy
- pandas
- tqdm
- matplotlib
- scikit-learn 1.2.2

You can install all required dependencies using the following command:

```bash
pip install torch torchvision numpy pandas tqdm matplotlib scikit-learn==1.2.2
```

## Steps to Run the Code

1. **Train the Model:**

   Run the following command to train the model:

   ```bash
   python main.py
   ```

   This will start the training process using the default settings defined in `config.py`.

2. **Modify Configuration:**

   If needed, modify the configuration parameters in `config.py` to fit your dataset or experiment setup. Key parameters include:

   - `batch_size`: Number of samples processed before updating the model.
   - `epoch`: Number of training cycles.
   - `sembed_size`: Size of the sample embedding layer.
   - `data_length`: Length of input data samples.
   - `test_dir`: Directory path for the test dataset.
   - `resultpath`: Path where the model results will be stored.
   - `path`: Path to the training dataset.
   - `Resolution_data`: Data resolution parameter, if applicable.

Make sure to adjust these parameters based on your dataset characteristics or computational resources.